package com.example.sefinsa_app.migrations;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;

import com.example.sefinsa_app.models.Cliente;
import com.example.sefinsa_app.models.Ruta;

public class RutaMigration extends SQLiteOpenHelper {

    private static final String NOMBRE_BASE_DE_DATOS = "sefinsa_proyecto2",
    //private static final String NOMBRE_BASE_DE_DATOS = "sefinsa_test",
            NOMBRE_TABLA = "rutas";
    private static final int VERSION_BASE_DE_DATOS = 12;

    public RutaMigration(Context context) {
        super(context, NOMBRE_BASE_DE_DATOS, null, VERSION_BASE_DE_DATOS);
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        db.execSQL(String.format("CREATE TABLE IF NOT EXISTS %s(" +
                "id integer primary key, " +
                "nombre_ruta text, " +
                "empleado_id int, " +
                "status int, " +
                "created_at text, " +
                "updated_at text) "
                , NOMBRE_TABLA));

    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL(String.format("DROP TABLE IF EXISTS " + NOMBRE_TABLA));
        onCreate(db);
    }
    @Override
    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        // Manejo personalizado de "downgrade", por ejemplo, eliminar la base de datos
        db.execSQL("DROP TABLE IF EXISTS " + NOMBRE_TABLA);
        onCreate(db);
    }
    public void deleteAllRutas() {
        SQLiteDatabase db = this.getWritableDatabase();
        db.execSQL("DELETE FROM rutas");
        db.close();
    }
    public boolean doesRutaExist(SQLiteDatabase db, String id) {
        String query = "SELECT COUNT(*) FROM " + NOMBRE_TABLA + " WHERE id = ?";
        Cursor cursor = db.rawQuery(query, new String[]{id});
        boolean exists = false;

        if (cursor != null) {
            cursor.moveToFirst();
            exists = cursor.getInt(0) > 0;
            cursor.close();
        }

        return exists;
    }

    public Ruta getRutaById(SQLiteDatabase db, String id) {
        String query = "SELECT id, nombre_ruta, empleado_id, status, created_at, updated_at  FROM " + NOMBRE_TABLA + " WHERE id = ?";
        Log.d("getRutaById", "Ejecutando consulta: " + query + " con id: " + id);

        Cursor cursor = db.rawQuery(query, new String[]{id});
        Ruta ruta = null;

        if (cursor != null && cursor.moveToFirst()) {
            //Log.d("getClienteById", "Cursor movido a la primera posición. Leyendo datos...");
            String id2 = cursor.getString(0);
            String nombre_ruta = cursor.getString(1);
            String empleado_id = cursor.getString(2);
            String status = cursor.getString(3);
            String created_at = cursor.getString(4);
            String updated_at = cursor.getString(5);

            // Construir el objeto Cliente
            ruta = new Ruta(id2, nombre_ruta, empleado_id, status, created_at,
                    updated_at);

            cursor.close();
        } else {
            Log.e("getClienteById", "No se encontró ningún registro con el id: " + id);
        }

        //Log.d("getClienteById", "Cliente obtenido: " + (ruta != null ? ruta.toString() : "null"));
        return ruta;
    }

    public void updateRutaInSQLite(SQLiteDatabase db, Ruta ruta) {
        ContentValues values = new ContentValues();
        values.put("nombre_ruta", ruta.getNombre_ruta());
        values.put("empleado_id", ruta.getEmpleado_id());
        values.put("status", ruta.getStatus());
        values.put("created_at", ruta.getCreated_at());
        values.put("updated_at", ruta.getUpdated_at());

        // Actualizar el registro
        db.update(NOMBRE_TABLA, values, "id = ?", new String[]{ruta.getId()});
    }
}
